/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Calib;
import cds.aladin.Coord;
import cds.aladin.FilterProperties;
import cds.aladin.MyInputStream;
import cds.aladin.Server;
import cds.fits.HeaderFits;
import cds.tools.Util;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class IDHAGenerator
extends JFrame {
    Server server;
    static final String CR = Util.CR;
    static long keptMask = 35184372096897L;
    private static final String BARATIN_OBSERVING_PROGRAM = "<DESCRIPTION>" + CR + "This is a few resource information for the" + CR + "ObservingProgram " + CR + "</DESCRIPTION>" + CR + "<FIELD ID=\"Name\" name=\"Name\" datatype=\"char\" ucd=\"ID_SURVEY\">" + CR + "<DESCRIPTION> ObservingProgram Name </DESCRIPTION>" + CR + "</FIELD>" + CR + "<FIELD ID=\"Organisation\" name=\"Organisation\" datatype=\"char\" ucd=\"CURATOR\">" + CR + "<DESCRIPTION> Name of Organisation(s) " + CR + "performing Observing Program" + CR + "</DESCRIPTION>" + CR + "</FIELD>" + CR + "<FIELD ID=\"Begin\" name=\"beginning_date\" datatype=\"char\">" + CR + "<DESCRIPTION> Begin date of the survey" + CR + "</DESCRIPTION>" + CR + "</FIELD>" + CR + "<FIELD ID=\"End\" name=\"end date\" datatype=\"char\">" + CR + "<DESCRIPTION> End date of Observing program" + CR + "</DESCRIPTION>" + CR + "</FIELD>" + CR + "<FIELD ID=\"SpectralDomain\" name=\"SpectralCoverageName\" datatype=\"char\">" + CR + "<DESCRIPTION> General spectral domain (Optical X-ray ...)" + CR + "</DESCRIPTION>" + CR + "</FIELD>";
    private static final String BARATIN_OBSERVATION_GROUP = "<DESCRIPTION> This is a subset of images" + CR + "belonging to a survey, an experiment," + CR + "and organised according to the same" + CR + "common criterion. e.g. exemple of" + CR + "criterion: color or wavelength," + CR + "polarimetry, etc... exemple of" + CR + "Observation_Group: POSSII band J," + CR + "DENIS band K, etc.." + CR + "</DESCRIPTION>" + CR + "<FIELD ID=\"Selection_Criterion\" name=\"Selection_Criterion\" datatype=\"char\">" + CR + "<DESCRIPTION> Sampled Parameter" + CR + "</DESCRIPTION>" + CR + "</FIELD>" + CR + "<FIELD ID=\"Selection-Range\" name=\"Selection-Range\" datatype=\"char\">" + CR + "<DESCRIPTION> Constraint on sampled parameter" + CR + "</DESCRIPTION>" + CR + "</FIELD>";
    private static final String BARATIN_OBSERVATION = "<DESCRIPTION>" + CR + "This resource describes list of processed observations " + CR + "</DESCRIPTION>" + CR + "<FIELD ID=\"Observation_Name\" name=\"Observation_Name\" datatype=\"char\" ucd=\"ID_IMAGE\">" + CR + "<DESCRIPTION>" + CR + "Name of the Observation" + CR + "</DESCRIPTION>" + CR + "</FIELD>" + CR + "<FIELD ID=\"ReferenceNumber\" name=\"ReferenceNumber\" datatype=\"char\" ucd=\"ID_IMAGE\">" + CR + "<DESCRIPTION>" + CR + "Reference Number of the Image" + CR + "</DESCRIPTION>" + CR + "</FIELD>" + CR + "<FIELD ID=\"Size_alpha\" name=\"Size_alpha\" datatype=\"float\" precision=\"7\" width=\"11\" unit=\"deg\" ucd=\"INST_DET_SIZE\">" + CR + "<DESCRIPTION>" + CR + "Observation range in alpha (angular) " + CR + "</DESCRIPTION>" + CR + "</FIELD>" + CR + "<FIELD ID=\"Size_delta\" name=\"Size_delta\" datatype=\"float\" precision=\"F7\" width=\"11\" unit=\"deg\" ucd=\"INST_DET_SIZE\">" + CR + "<DESCRIPTION>" + CR + "Observation range in delta (angular) " + CR + "</DESCRIPTION>" + CR + "</FIELD>" + CR + "<FIELD ID=\"PixelSize\" name=\"Angular Pixel Size\"  datatype=\"float\" unit =\"deg\">" + CR + "<DESCRIPTION>" + CR + "Pixel size measured in sky units" + CR + "</DESCRIPTION>" + CR + "</FIELD>" + CR + "<FIELD ID=\"Origin\" name=\"Origin\" datatype=\"char\">" + CR + "<DESCRIPTION>" + CR + "Data provider references" + CR + "</DESCRIPTION>" + CR + "</FIELD>" + CR + "<FIELD ID=\"OriginalCoding \" name=\"OriginalCoding\" datatype=\"char\">" + CR + "<DESCRIPTION>" + CR + "Image coding provided by the data producer" + CR + "</DESCRIPTION>" + CR + "</FIELD>" + CR + "<FIELD ID=\"AvailableCodings\" name=\"AvailableCodings\" datatype=\"char\">" + CR + "<DESCRIPTION>" + CR + "Codings which may be  produced on the fly" + CR + "</DESCRIPTION>" + CR + "</FIELD>" + CR + "<FIELD ID=\"alpha\" name=\"CentralPoint_RA\" ucd=\"POS_EQ_RA_MAIN\"  datatype=\"float\" precision=\"F7\" width=\"11\" unit=\"deg\">" + CR + "<DESCRIPTION>" + CR + "Position of center\t" + CR + "</DESCRIPTION>" + CR + "</FIELD>" + CR + "<FIELD ID=\"delta\" name=\"CentralPoint_DEC\" ucd=\"POS_EQ_DEC_MAIN\"  datatype=\"float\" precision=\"F7\" width=\"11\" unit=\"deg\">" + CR + "<DESCRIPTION>" + CR + "Position of center\t" + CR + "</DESCRIPTION>" + CR + "</FIELD>" + CR + "<FIELD ID=\"date\"  name=\"DateAndTime\" datatype=\"char\">" + CR + "<DESCRIPTION>" + CR + "Observation date" + CR + "</DESCRIPTION>" + CR + "</FIELD>" + CR + "<FIELD ID=\"AP\" name=\"Position Angle\"  datatype=\"float\" precision=\"F7\"  width=\"11\" unit=\"deg\">" + CR + "<DESCRIPTION>" + CR + "Position Angle of th Y axis" + CR + "</DESCRIPTION>" + CR + "</FIELD>";
    private static final String BARATIN_STORAGE_MAPPING = "<DESCRIPTION>" + CR + "This resource describes list of processed observations " + CR + "</DESCRIPTION>" + CR + "<FIELD ref=\"Observation_Name\" >" + CR + "</FIELD>" + CR + "<FIELD ID=\"Cutout\" name=\"Organisation\"  datatype=\"char\">" + CR + "<DESCRIPTION>" + CR + "Status of cutout availability " + CR + "</DESCRIPTION>" + CR + "</FIELD>" + CR + "<FIELD ID=\"number\" name=\"NumberOfPatches\"  datatype=\"int\">" + CR + "<DESCRIPTION>" + CR + "Number of subimages" + CR + "</DESCRIPTION>" + CR + "</FIELD>" + CR + "<FIELD ID=\"size\" name=\"Maximum size\"  datatype=\"int\">" + CR + "<DESCRIPTION>" + CR + "Maximum size " + CR + "</DESCRIPTION>" + CR + "</FIELD>";
    private static final String BARATIN_STORED_IMAGE = "<DESCRIPTION>" + CR + "This resource describes the actual retrieved file " + CR + "</DESCRIPTION>" + CR + "<FIELD ref=\"Observation_Name\" >" + CR + "</FIELD>" + CR + "<FIELD ID=\"Location\" name=\"LinktoPixels\" datatype=\"char\">" + CR + "<DESCRIPTION>" + CR + "File location" + CR + "</DESCRIPTION>" + CR + "</FIELD>";
    private static final String[] FIELD_ID = new String[]{"alpha", "delta", "Size_alpha", "Size_delta", "AP"};
    static final String SAVE_DIR_FILE = ".aladin_idha";
    private Vector progs = new Vector();
    private ObsProg currentProg;
    private static final String allFiles = "*";
    File[] dirs;
    File[] files;

    IDHAGenerator() {
        super("IDHA generator");
        Aladin.setIcon(this);
    }

    IDHAGenerator(Server server) {
        this();
        this.server = server;
    }

    private ObsProg addObsProg(String s) {
        if (s.length() > 0) {
            ObsProg prog = new ObsProg(s);
            this.progs.addElement(prog);
            if (this.currentProg == null) {
                this.currentProg = prog;
            }
            return prog;
        }
        return null;
    }

    protected void reset() {
        this.progs.removeAllElements();
    }

    protected InputStream getStream(File startDir, Component c) {
        int answer;
        File descFile = this.buildDescFile(startDir);
        if (descFile.exists() && (answer = JOptionPane.showConfirmDialog(c, "Do you want to use existing description file ?", "Confirmation", 0)) == 0) {
            try {
                Aladin.trace(3, "Return stream from existing description file");
                return new BufferedInputStream(new FileInputStream(descFile));
            }
            catch (Exception e) {
                return new BufferedInputStream(new ByteArrayInputStream("".getBytes()));
            }
        }
        if (this.server != null) {
            this.server.waitCursor();
        }
        Aladin.trace(3, "Build description file for directory " + startDir);
        this.doScan(startDir);
        StringBuffer vot = this.generateXML();
        try {
            DataOutputStream out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(descFile)));
            Aladin.trace(3, "Write file " + descFile);
            out.writeBytes(vot.toString());
            out.close();
        }
        catch (IOException e) {
            System.out.println("Could not produce write description file " + descFile + " : " + e);
        }
        if (this.server != null) {
            this.server.defaultCursor();
        }
        return new BufferedInputStream(new ByteArrayInputStream(vot.toString().getBytes()));
    }

    private File buildDescFile(File dir) {
        return new File(dir + File.separator + SAVE_DIR_FILE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkFile(File file) {
        MyInputStream mis = null;
        try {
            mis = new MyInputStream(new FileInputStream(file));
            mis = mis.startRead();
            long type = mis.getType();
            boolean bl = (type & keptMask) != 0L;
            return bl;
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (mis != null) {
                try {
                    mis.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private void doScan(File startDir) {
        Aladin.trace(3, "Setting start directory: " + startDir);
        this.getFilesAndDirs(startDir);
        File[] obsProgDirs = this.dirs;
        File[] filesFirstLevel = this.files;
        ObsProg opFantome = this.addObsProg("First level files obsprog");
        opFantome.hide = true;
        ObsGroup group = new ObsGroup("");
        opFantome.groups.addElement(group);
        for (int i = 0; i < filesFirstLevel.length; ++i) {
            if (!this.checkFile(filesFirstLevel[i])) continue;
            Image curImage = new Image(filesFirstLevel[i]);
            group.images.addElement(curImage);
            this.processImage(curImage);
        }
        Aladin.trace(3, "Retrieving Observing programs directories: " + obsProgDirs.length + " directories found");
        for (int i = 0; i < obsProgDirs.length; ++i) {
            String progName = obsProgDirs[i].getName();
            Aladin.trace(3, "Adding Observation Program " + progName);
            ObsProg curProg = this.addObsProg(progName);
            this.fillObsProg(curProg, new Vector(), obsProgDirs[i], 0);
        }
        this.currentProg = null;
        this.cleanup();
    }

    private void cleanup() {
        Vector<ObsProg> toDel = new Vector<ObsProg>();
        Enumeration e = this.progs.elements();
        while (e.hasMoreElements()) {
            ObsProg op = (ObsProg)e.nextElement();
            if (op.groups.size() != 0) continue;
            toDel.addElement(op);
        }
        e = toDel.elements();
        while (e.hasMoreElements()) {
            this.progs.removeElement(e.nextElement());
        }
    }

    private void scanDirectory() {
        FileDialog fd = new FileDialog((Frame)this, "Go into the start directory", 0);
        fd.setFile(allFiles);
        fd.show();
        String dir = fd.getDirectory();
        String name = fd.getFile();
        String s = (dir == null ? "" : dir) + (name == null ? "" : name);
        if (name == null) {
            return;
        }
        File startDir = new File(dir);
        this.doScan(startDir);
    }

    private void fillObsProg(ObsProg prog, Vector values, File dir, int level) {
        this.getFilesAndDirs(dir);
        File[] subdirs = this.dirs;
        if (subdirs == null || subdirs.length == 0) {
            ObsGroup group = new ObsGroup("group" + prog.groups.size());
            for (int i = 0; i < values.size(); ++i) {
                group.criteriaValues.put(prog.criteriaClasses.elementAt(i), values.elementAt(i));
            }
            String[] list = dir.list();
            FilterProperties.sortLexico(list);
            for (int i = 0; i < list.length; ++i) {
                File f = new File(dir, list[i]);
                if (!this.checkFile(f)) continue;
                Image curImage = new Image(f);
                if (curImage.file.getName().indexOf(SAVE_DIR_FILE) >= 0) continue;
                group.images.addElement(curImage);
                this.processImage(curImage);
            }
            if (group.images.size() > 0) {
                prog.groups.addElement(group);
            }
        } else {
            String newCrit = "criterion" + level;
            if (prog.criteriaClasses.indexOf(newCrit) < 0) {
                prog.criteriaClasses.addElement(newCrit);
                Aladin.trace(3, "Adding constraint " + newCrit);
            }
            for (int i = 0; i < subdirs.length; ++i) {
                Vector v = new Vector();
                Enumeration enumVal = values.elements();
                while (enumVal.hasMoreElements()) {
                    v.addElement(enumVal.nextElement());
                }
                v.addElement(subdirs[i].getName());
                Aladin.trace(3, "Adding constraint value " + subdirs[i].getName());
                this.fillObsProg(prog, v, subdirs[i], level + 1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processImage(Image image) {
        Coord coo;
        HeaderFits hf = null;
        MyInputStream myStream = null;
        try {
            myStream = new MyInputStream(new FileInputStream(image.file));
            myStream = myStream.startRead();
            hf = new HeaderFits(myStream);
        }
        catch (Exception e) {
            Aladin.trace(3, "Error : could not create HeaderFits object");
            return;
        }
        finally {
            if (myStream != null) {
                try {
                    myStream.close();
                }
                catch (Exception exception) {}
            }
        }
        Calib calib = null;
        try {
            calib = new Calib(hf);
        }
        catch (Exception e) {
            Aladin.trace(3, "Error : could not create Calib object");
            return;
        }
        try {
            coo = calib.getImgCenter();
        }
        catch (Exception e) {
            Aladin.trace(3, "Error while retrieving image center");
            coo = null;
        }
        if (coo != null) {
            image.values[0] = Float.toString((float)coo.al);
            image.values[1] = Float.toString((float)coo.del);
        }
        image.values[2] = Float.toString((float)calib.getImgWidth());
        image.values[3] = Float.toString((float)calib.getImgHeight());
        image.values[4] = Float.toString((float)calib.getProjRot());
    }

    private void getFilesAndDirs(File dir) {
        String[] list = dir.list();
        FilterProperties.sortLexico(list);
        Vector<File> v = new Vector<File>();
        Vector<File> f = new Vector<File>();
        for (int i = 0; i < list.length; ++i) {
            File curFile = new File(dir, list[i]);
            if (curFile.isDirectory()) {
                v.addElement(curFile);
                continue;
            }
            if (curFile.getName().indexOf(SAVE_DIR_FILE) >= 0) continue;
            f.addElement(curFile);
        }
        this.dirs = new File[v.size()];
        v.copyInto(this.dirs);
        v = null;
        this.files = new File[f.size()];
        f.copyInto(this.files);
        f = null;
    }

    private void writeEmptyTD(StringBuffer sb, int nb) {
        for (int i = 0; i < nb; ++i) {
            sb.append("<TD></TD>");
        }
    }

    private StringBuffer generateXML() {
        boolean firstProg = true;
        boolean firstGroup = true;
        boolean firstObs = true;
        boolean firstStorageMapping = true;
        boolean firstStoredImage = true;
        StringBuffer ret = new StringBuffer();
        ret.append("<?xml version=\"1.0\"?>" + CR + "<!DOCTYPE VOTABLE SYSTEM \"http://us-vo.org/xml/VOTable.dtd\">");
        ret.append(CR + "<VOTABLE ID=\"v1.0\">");
        Enumeration eProg = this.progs.elements();
        while (eProg.hasMoreElements()) {
            ObsProg curProg = (ObsProg)eProg.nextElement();
            if (!curProg.hide) {
                ret.append(CR + "<RESOURCE name=\"ObservingProgram\">");
                if (firstProg) {
                    ret.append(CR + "<TABLE ID=\"ObservingProgram\">");
                    ret.append(CR + BARATIN_OBSERVING_PROGRAM);
                    firstProg = false;
                } else {
                    ret.append(CR + "<TABLE ref=\"ObservingProgram\">");
                }
                ret.append(CR + "<DATA><TABLEDATA>");
                ret.append(CR + "<TR>");
                ret.append("<TD>" + curProg.name + "</TD>");
                this.writeEmptyTD(ret, 4);
                ret.append("</TR>");
                ret.append(CR + "</TABLEDATA></DATA>");
                ret.append(CR + "</TABLE>");
            }
            Enumeration eGroup = curProg.groups.elements();
            while (eGroup.hasMoreElements()) {
                File file;
                ObsGroup curGroup = (ObsGroup)eGroup.nextElement();
                ret.append(CR + "<RESOURCE name=\"Observation_Group\">");
                if (firstGroup) {
                    ret.append(CR + "<TABLE ID=\"Observation_Group\">");
                    ret.append(CR + BARATIN_OBSERVATION_GROUP);
                    firstGroup = false;
                } else {
                    ret.append(CR + "<TABLE ref=\"Observation_Group\">");
                }
                ret.append(CR + "<DATA><TABLEDATA>");
                Enumeration eCrit = curProg.criteriaClasses.elements();
                while (eCrit.hasMoreElements()) {
                    String crit = (String)eCrit.nextElement();
                    ret.append(CR + "<TR><TD>" + crit + "</TD><TD>" + curGroup.criteriaValues.get(crit) + "</TD></TR>");
                }
                if (curProg.criteriaClasses.size() == 0 && !curProg.hide) {
                    ret.append(CR + "<TR><TD>Group</TD><TD>" + curGroup.name + "</TD></TR>");
                }
                ret.append(CR + "</TABLEDATA></DATA>");
                ret.append(CR + "</TABLE>");
                ret.append(CR + "<RESOURCE name=\"Observation\">");
                if (firstObs) {
                    ret.append(CR + "<TABLE ID=\"Observation\">");
                    ret.append(CR + BARATIN_OBSERVATION);
                    firstObs = false;
                } else {
                    ret.append(CR + "<TABLE ref=\"Observation\">");
                }
                ret.append(CR + "<DATA><TABLEDATA>");
                Enumeration eFile = curGroup.images.elements();
                while (eFile.hasMoreElements()) {
                    Image image = (Image)eFile.nextElement();
                    ret.append(CR + "<TR>");
                    ret.append("<TD>" + this.buildName(image.file) + "</TD>");
                    this.writeEmptyTD(ret, 1);
                    ret.append("<TD>" + image.values[2] + "</TD>");
                    ret.append("<TD>" + image.values[3] + "</TD>");
                    this.writeEmptyTD(ret, 4);
                    ret.append("<TD>" + image.values[0] + "</TD>");
                    ret.append("<TD>" + image.values[1] + "</TD>");
                    this.writeEmptyTD(ret, 1);
                    ret.append("<TD>" + image.values[4] + "</TD>");
                    ret.append(CR + "</TR>");
                }
                ret.append(CR + "</TABLEDATA></DATA>");
                ret.append(CR + "</TABLE>");
                ret.append(CR + "</RESOURCE>");
                ret.append(CR + "<RESOURCE name=\"StorageMapping\">");
                if (firstStorageMapping) {
                    ret.append(CR + "<TABLE ID=\"StorageMapping\">");
                    ret.append(CR + BARATIN_STORAGE_MAPPING);
                    firstStorageMapping = false;
                } else {
                    ret.append(CR + "<TABLE ref=\"StorageMapping\">");
                }
                ret.append(CR + "<DATA><TABLEDATA>");
                eFile = curGroup.images.elements();
                while (eFile.hasMoreElements()) {
                    file = ((Image)eFile.nextElement()).file;
                    ret.append(CR + "<TR>");
                    ret.append("<TD>" + this.buildName(file) + "</TD>");
                    this.writeEmptyTD(ret, 3);
                    ret.append("</TR>");
                }
                ret.append(CR + "</TABLEDATA></DATA>");
                ret.append(CR + "</TABLE>");
                ret.append(CR + "</RESOURCE>");
                ret.append(CR + "<RESOURCE name=\"StoredImage\">");
                if (firstStoredImage) {
                    ret.append(CR + "<TABLE ID=\"StoredImage\">");
                    ret.append(CR + BARATIN_STORED_IMAGE);
                    firstStoredImage = false;
                } else {
                    ret.append(CR + "<TABLE ref=\"StoredImage\">");
                }
                ret.append(CR + "<DATA><TABLEDATA>");
                eFile = curGroup.images.elements();
                while (eFile.hasMoreElements()) {
                    String path;
                    file = ((Image)eFile.nextElement()).file;
                    try {
                        path = file.getCanonicalPath();
                    }
                    catch (IOException ioe) {
                        path = "";
                    }
                    ret.append(CR + "<TR><TD>" + this.buildName(file) + "</TD><TD>file://" + path + "</TD></TR>");
                }
                ret.append(CR + "</TABLEDATA></DATA>");
                ret.append(CR + "</TABLE>");
                ret.append(CR + "</RESOURCE>");
                ret.append(CR + "</RESOURCE>");
            }
            if (curProg.hide) continue;
            ret.append(CR + "</RESOURCE>");
        }
        ret.append(CR + "</VOTABLE>");
        return ret;
    }

    private String buildName(File file) {
        String name = file.getName();
        return name;
    }

    class ObsProg {
        boolean hide = false;
        Vector groups = new Vector();
        Vector criteriaClasses = new Vector();
        String name;

        ObsProg(String name) {
            this.name = name;
        }
    }

    class ObsGroup {
        Vector images = new Vector();
        Hashtable criteriaValues = new Hashtable();
        String name;

        ObsGroup(String name) {
            this.name = name;
        }
    }

    class Image {
        File file;
        String[] values;

        Image(File file) {
            this.file = file;
            this.values = new String[FIELD_ID.length];
            for (int i = 0; i < this.values.length; ++i) {
                this.values[i] = "";
            }
        }
    }
}

